<?php
if( !function_exists('epress_assets_setup') ){
    function epress_assets_setup(){
        /*
        * Make theme available for translation.
        * If you're building a theme based on epress, use a find and replace
        * to change 'epress' to the name of your theme in all the template files
        */
        load_theme_textdomain( 'epress', get_theme_file_path('/languages/') );
        
        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );
        
        /*
        * Let WordPress manage the document title.
        * By adding theme support, we declare that this theme does not use a
        * hard-coded <title> tag in the document head, and expect WordPress to
        * provide it for us.
        */
        add_theme_support( 'title-tag' );
        
        /*
        * Enable support for custom logo.
        */
        add_theme_support( 'custom-logo', array(
            'flex-height' => true
        ) );

        /*
        * Enable support for woocommerce.
        */
        if( class_exists( 'WooCommerce' ) ){   
            add_theme_support( 'woocommerce', 
                array(
                    'thumbnail_image_width' => 400,
                    'gallery_thumbnail_image_width' => 300,
                    'single_image_width'    => 800,
                    'product_grid' => array(
                        'default_rows'    => 4,
                        'min_rows'        => 1,
                        'max_rows'        => 6,
                        'default_columns' => 3,
                        'min_columns'     => 1,
                        'max_columns'     => 5,
                    ),
                )
            );
            add_theme_support( 'wc-product-gallery-zoom' );
            add_theme_support( 'wc-product-gallery-lightbox' );
            add_theme_support( 'wc-product-gallery-slider' );
        }
        // Setup the WordPress core custom background feature.
        /**
         * Filter epress custom-header support arguments.
         *
         * @since epress 1.0
         *
         * @param array $args {
         *     An array of custom-header support arguments.
         *
         *     @type string $default-color     		Default color of the header.
         *     @type string $default-attachment     Default attachment of the header.
         * }
         */
        add_theme_support( 
            'custom-background',
                apply_filters(
                    'epress_custom_background_args', array(
                        'default-color'      => 'ffffff'
                    )
            )
        );
        // Setup the WordPress core custom header background feature.    
        add_theme_support( 'custom-header', apply_filters( 'epress_custom_header_args', array(
            'default-text-color'     => 'ffffff',
            'wp-head-callback'       => 'epress_header_style',
        ) ) );
        
        if ( ! function_exists( 'epress_header_style' ) ) {
           function epress_header_style() {
                $header_text_color = get_header_textcolor();
                if ( get_theme_support( 'custom-header', 'default-text-color' ) === $header_text_color ) {
                    return;
                }
            } 
        }        
		
		
        
        /*
        * Enable support for Post Thumbnails on posts and pages.
        *
        * @link https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
        */
        add_theme_support( 'post-thumbnails' );

        // This theme uses wp_nav_menu() in two locations.
        register_nav_menus( array(
            'primary_menu' => esc_html__( 'Primary Menu', 'epress' )
        ) );

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ) );

        /*
         * Enable support for Post Formats.
         *
         * See: https://codex.wordpress.org/Post_Formats
         */
        add_theme_support( 'post-formats', array(
            'aside',
            'image',
            'video',
            'quote',
            'link',
            'gallery',
            'status',
            'audio',
            'chat',
        ) );

        /*
         * This theme styles the visual editor to resemble the theme style,
         * specifically font, colors, icons, and column width.
         */
        add_editor_style( array( 'assets/css/editor-style.css' ) );
        
        add_image_size( 'epress_blog_thumb' ,'750','500',true );
		add_image_size( 'featured-small', 100, 80, true );        
        
        // Indicate widget sidebars can use selective refresh in the Customizer.
        add_theme_support( 'customize-selective-refresh-widgets' );
        
        
        // Used for OnePage Template Back Link 
        if( !function_exists('epress_detect_homepage') ){
            function epress_detect_homepage() {
                $onepage = '';
                $onepage = get_post_meta( get_the_ID(), '_epress_one_page_scroll', true );
                /*If front page is set to display a static page, get the URL of the posts page.*/
                $homepage_id = get_option( 'page_on_front' );
                /*current page id*/
                $current_page_id = ( is_page( get_the_ID() ) ) ? get_the_ID() : '';
                if( $homepage_id == $current_page_id or $onepage == 'on'  ) {
                    return true;
                } else {
                    return false;
                }

            }
        }
        
    }
}
add_action( 'after_setup_theme','epress_assets_setup' );

/**
 * Sets the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 *
 * @since epress 1.0.0
 */
if( !function_exists('epress_content_width') ){    
    function epress_content_width() {
        $GLOBALS['content_width'] = apply_filters( 'epress_content_width', 750 );
    }
}
add_action( 'after_setup_theme', 'epress_content_width', 0 );

/**
 * Registers a widget area.
 *
 * @link https://developer.wordpress.org/reference/functions/register_sidebar/
 *
 * @since epress 1.0.0
 */
if( !function_exists('epress_widgets_init') ){
    function epress_widgets_init() {
        if( class_exists('Redux') ){
            global $epress_opt;
        }else{
            $epress_opt = array();
            $epress_opt['widget_title_bar'] = 'bottom-bar';
            $epress_opt['footer_widget_title_bar'] = 'no-bar';
        }        
        if( !isset($epress_opt['widget_title_bar']) ){
            $epress_opt['widget_title_bar'] = 'bottom-bar';
        }
        if( !isset($epress_opt['footer_widget_title_bar']) ){
            $epress_opt['footer_widget_title_bar'] = 'no-bar';
        }
        register_sidebar( array(
            'name'          => esc_html__( 'Sidebar', 'epress' ),
            'id'            => 'sidebar-1',
            'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'epress' ),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h3 class="widget-title '.esc_attr($epress_opt['widget_title_bar']).'">',
            'after_title'   => '<span></span></h3>',
        ) );
        
        if( class_exists( 'WooCommerce' ) ){            
            register_sidebar( array(
                'name'          => esc_html__( 'WooCommerce Sidebar', 'epress' ),
                'id'            => 'sidebar-wc',
                'description'   => esc_html__( 'Add widgets here to appear in your woocommerce sidebar.', 'epress' ),
                'before_widget' => '<section id="%1$s" class="widget %2$s">',
                'after_widget'  => '</section>',
                'before_title'  => '<h3 class="widget-title '.esc_attr($epress_opt['widget_title_bar']).'">',
                'after_title'   => '<span></span></h3>',
            ) );
        }
        
        register_sidebar( array(
            'name'          => esc_html__( 'Footer Widget', 'epress' ),
            'id'            => 'sidebar-2',
            'description'   => esc_html__( 'Add footer bottom widgets.', 'epress' ),
            'before_widget' => '<section id="%1$s" class="widget footer-widget %2$s col-xs-12 col-sm-3 xs-full masonry-item">',
            'after_widget'  => '</section>',
            'before_title'  => '<h4 class="widget-title '.esc_attr($epress_opt['footer_widget_title_bar']).'">',
            'after_title'   => '<span></span></h4>',
        ) );
    }
}
add_action( 'widgets_init', 'epress_widgets_init' );

if ( !function_exists( 'epress_fonts_url' ) ) {
    /**
     * Register Google fonts for epress.
     *
     * Create your own epress_fonts_url() function to override in a child theme.
     *
     * @since epress 1.0
     *
     * @return string Google fonts URL for the theme.
     */
    
    function epress_fonts_url() {
        $fonts_url = '';
        $fonts     = array();
        $subsets   = 'latin,latin-ext';
        /* translators: If there are characters in your language that are not supported by Roboto, translate this to 'off'. Do not translate into your own language. */
        $fonts[] = 'Karla:400,700';
        $fonts[] = 'Poppins:300,400,500,600,700&display=swap';

        if ( $fonts ) {
            $fonts_url = add_query_arg( array(
                'family' =>  implode( '|', $fonts ),
                'subset' =>  $subsets,
            ), 'https://fonts.googleapis.com/css' );
        }
        return esc_url_raw($fonts_url);
    }
    
    
    
}
/**
 * Enqueues scripts and styles.
 *
 * @since epress 1.0.0
 */
if( !function_exists('epress_enqueue_scripts') ){
    function epress_enqueue_scripts() {
        if ( class_exists( 'Redux' ) ) {
            global $epress_opt;
        }else{
            $epress_opt = array();
            $epress_opt['action_button_radius'] =
            $epress_opt['read_more_radius']  =
            $epress_opt['widget_box_radius'] =
            $epress_opt['post_image_radius'] =
            $epress_opt['post_box_radius'] =
            $epress_opt['scr_btn_radius'] =
            $epress_opt['post_image_box_shadow'] =
            $epress_opt['menuarea_shadow'] =
            $epress_opt['sticky_menuarea_shadow'] =
            $epress_opt['widget_box_shadow'] =
            $epress_opt['scr_btn_shadow'] =
            $epress_opt['post_box_box_shadow'] =
            $epress_opt['read_more_shadow'] =
            $epress_opt['preloader_color'] =
            $epress_opt['custom_css'] = '';
            $epress_opt['is_scroll_up'] = true;
            $epress_opt['preloader_color'] = array(
                'from' => '#ffffff',
                'to' => '#000000',
            );
        }

        $menu_text_color = get_post_meta( get_the_ID(), '_epress_menu_text_color', true );
        $menu_hover_text_color = get_post_meta( get_the_ID(), '_epress_menu_hover_text_color', true );
        $menu_item_active_bar_color = get_post_meta( get_the_ID(), '_epress_menu_item_active_bar_color', true );
        
        // Add google fonts, used in the main stylesheet.
        wp_enqueue_style( 'epress-fonts', epress_fonts_url(), array(), null );

        // Add Font-awesome, used for font icons.
        wp_enqueue_style( 'font-awesome-5', get_theme_file_uri('/assets/css/font-awesome-5.css'), array(), '1.0.1' );

        wp_register_style( 'epress-flaticon', get_theme_file_uri('/assets/css/flaticon.css'), array(), '1.0.1' );

        wp_enqueue_style( 'epress-flaticon' );

        // Add Bootstrap, Used for default grid system.
        wp_enqueue_style( 'bootstrap', get_theme_file_uri('/assets/css/bootstrap-min.css'), array(), '3.3.7' );
        
        
        // Add slicknav, Used for responsive mobile menu.
        wp_enqueue_style( 'slicknav', get_theme_file_uri('/assets/css/slicknav.css'), array(), '1.0.10' );
        
        // Add epress Theme CSS, Used for important structure style.
        wp_enqueue_style( 'epress-theme', get_theme_file_uri('/assets/css/theme.css'), array(), '1.0.0' );
               
        // Add Normalizer, Used for remove default tag style.
        wp_enqueue_style( 'normalizer', get_theme_file_uri('/assets/css/normalize.css'), array(), '1.0.0' );
        
        if( class_exists('Give') ){
            wp_enqueue_style( 'give-edit', get_theme_file_uri('/assets/css/give-edit.css'), array(), '1.0.0' );
        }

        if( class_exists( 'woocommerce' ) ){
            // Add WooCommerce, Used for WooCommerce Style.
            wp_enqueue_style( 'epress-wc-style', get_theme_file_uri('/assets/css/wc-style.css'), array(), '1.0.0' );
        }
        
        // Theme stylesheet.
        wp_enqueue_style( 'epress-style', get_stylesheet_uri() );
                
        // Add responsive, Used for mobile style.
        wp_enqueue_style( 'epress-responsive', get_theme_file_uri('/assets/css/responsive.css'), array(), '1.0.0' );
        
        // Add html5shiv. Used for support html5 tag.
        wp_enqueue_script( 'html5shiv', get_theme_file_uri('/assets/js/vendor/html5shiv-min.js'), array(), '3.7.2' );
        wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );

        // Add respond. A polyfill is a browser fallback, made in JavaScript work in older browsers.
        wp_enqueue_script( 'respond', get_theme_file_uri('/assets/js/vendor/respond-min.js'), array(), '1.4.2' );
        wp_script_add_data( 'respond', 'conditional', 'lt IE 9' );
        
        // Add Bootstrap, Used for default normal effect.
        wp_enqueue_script( 'bootstrap', get_theme_file_uri('/assets/js/vendor/bootstrap-min.js'), array('jquery'), '3.3.7', true );
        
        // Add WordPress Default Masonry, Used for attach grid.
        wp_enqueue_script('jquery-masonry');
        
        // Add WordPress Default imagesloaded, Used for image load.        
        wp_enqueue_script('imagesloaded');
        
        // Add SlickNav, Used for responsive mobile menu.
        wp_enqueue_script( 'slicknav', get_theme_file_uri('/assets/js/slicknav-min.js'), array('jquery'), '1.0.10', true );
        
        // Add jQuery-Fitvids, Used for responsive Video.
        wp_enqueue_script( 'jquery-fitvids', get_theme_file_uri('/assets/js/fitvids.js'), array('jquery'), '1.1.0', true );
        
        // Add jQuery-Fitvids, Used for responsive Video.
        wp_enqueue_script( 'jquery-prefixfree', get_theme_file_uri('/assets/js/prefixfree-min.js'), array('jquery'), '1.1.0', true );
        
        // Add jQuery-Fitvids, Used for responsive Video.
        wp_enqueue_script( 'epress-skip-link-focus-fix', get_theme_file_uri('/assets/js/skip-link-focus-fix.js'), array('jquery'), '1.1.0', true );
        
        if( $epress_opt['is_scroll_up'] == true ):
            // Add scrollUp, Used for scrolling  button to top.
            wp_enqueue_script( 'scroll_up', get_theme_file_uri('/assets/js/scrollUp-min.js'), array('jquery'), '2.4.1', true );
        endif;
                   
        wp_enqueue_script( 'appear', get_theme_file_uri('/assets/js/appear.js'), array('jquery'), '1.0.0', true );

        wp_enqueue_script( 'epress-main', get_theme_file_uri('/assets/js/main.js'), array('jquery'), '1.0.0', true );  
        
        $custom_css = [];

        if( is_page() and has_post_thumbnail() ){
            $custom_css[] = sprintf('.header-area { background-image: url(%s) !important; }', esc_url(get_the_post_thumbnail_url()) );
        }elseif(!empty(get_header_image())){
            $custom_css[] = sprintf('.header-area { background-image: url(%s) }', esc_url(get_header_image()) );
        }     
        
        

        
        
        if( isset( $epress_opt['action_button_radius'] ) and !empty($epress_opt['action_button_radius']['top']) or !empty($epress_opt['action_button_radius']['bottom']) or !empty($epress_opt['action_button_radius']['left']) or !empty($epress_opt['action_button_radius']['right']) ){
            $custom_css[] = '.mainmenu-area .action-button { 
                border-radius: '.esc_attr($epress_opt['action_button_radius']['top']).' '.esc_attr($epress_opt['action_button_radius']['right']).' '.esc_attr($epress_opt['action_button_radius']['bottom']).' '.esc_attr($epress_opt['action_button_radius']['left']).';
            }';
        }
        if( isset( $epress_opt['read_more_radius'] ) and !empty($epress_opt['read_more_radius']['top']) or !empty($epress_opt['read_more_radius']['bottom']) or !empty($epress_opt['read_more_radius']['left']) or !empty($epress_opt['read_more_radius']['right']) ){
            $custom_css[] = '.post-content .read-more { 
                border-radius: '.esc_attr($epress_opt['read_more_radius']['top']).' '.esc_attr($epress_opt['read_more_radius']['right']).' '.esc_attr($epress_opt['read_more_radius']['bottom']).' '.esc_attr($epress_opt['read_more_radius']['left']).';
            }';
        }
        if( isset( $epress_opt['widget_box_radius'] ) and !empty($epress_opt['widget_box_radius']['top']) or !empty($epress_opt['widget_box_radius']['bottom']) or !empty($epress_opt['widget_box_radius']['left']) or !empty($epress_opt['widget_box_radius']['right']) ){
            $custom_css[] = '.sidebar .widget { 
                border-radius: '.esc_attr($epress_opt['widget_box_radius']['top']).' '.esc_attr($epress_opt['widget_box_radius']['right']).' '.esc_attr($epress_opt['widget_box_radius']['bottom']).' '.esc_attr($epress_opt['widget_box_radius']['left']).';
            }';
        }
        if( isset( $epress_opt['post_image_radius'] ) and !empty($epress_opt['post_image_radius']['top']) or !empty($epress_opt['post_image_radius']['bottom']) or !empty($epress_opt['post_image_radius']['left']) or !empty($epress_opt['post_image_radius']['right']) ){
            $custom_css[] = '.post-single .post-media { 
                border-radius: '.esc_attr($epress_opt['post_image_radius']['top']).' '.esc_attr($epress_opt['post_image_radius']['right']).' '.esc_attr($epress_opt['post_image_radius']['bottom']).' '.esc_attr($epress_opt['post_image_radius']['left']).';
            }';
        }
        if( isset( $epress_opt['post_box_radius'] ) and !empty($epress_opt['post_box_radius']['top']) or !empty($epress_opt['post_box_radius']['bottom']) or !empty($epress_opt['post_box_radius']['left']) or !empty($epress_opt['post_box_radius']['right']) ){
            $custom_css[] = '.posts-list .post-content { 
                border-radius: '.esc_attr($epress_opt['post_box_radius']['top']).' '.esc_attr($epress_opt['post_box_radius']['right']).' '.esc_attr($epress_opt['post_box_radius']['bottom']).' '.esc_attr($epress_opt['post_box_radius']['left']).';
            }';
        }  
        if( isset( $epress_opt['scr_btn_radius'] ) and !empty($epress_opt['scr_btn_radius']['top']) or !empty($epress_opt['scr_btn_radius']['bottom']) or !empty($epress_opt['scr_btn_radius']['left']) or !empty($epress_opt['scr_btn_radius']['right']) ){
            $custom_css[] = 'a#scrollUp { 
                border-radius: '.esc_attr($epress_opt['scr_btn_radius']['top']).' '.esc_attr($epress_opt['scr_btn_radius']['right']).' '.esc_attr($epress_opt['scr_btn_radius']['bottom']).' '.esc_attr($epress_opt['scr_btn_radius']['left']).';
            }';
        }  
        if( isset( $epress_opt['post_image_box_shadow'] ) ){
            $custom_css[] = '.post-single .post-media { 
                box-shadow: '.esc_attr($epress_opt['post_image_box_shadow']).';
            }';
        } 
        if( isset( $epress_opt['menuarea_shadow'] ) ){
            $custom_css[] = '.mainmenu-area { 
                box-shadow: '.esc_attr($epress_opt['menuarea_shadow']).';
            }';
        } 
        if( isset( $epress_opt['sticky_menuarea_shadow'] ) ){
            $custom_css[] = '.mainmenu-area.affix { 
                box-shadow: '.esc_attr($epress_opt['sticky_menuarea_shadow']).';
            }';
        } 
        if( isset( $epress_opt['widget_box_shadow'] ) ){
            $custom_css[] = '.sidebar .widget { 
                box-shadow: '.esc_attr($epress_opt['widget_box_shadow']).';
            }';
        }   
        if( isset( $epress_opt['scr_btn_shadow'] ) ){
            $custom_css[] = 'a#scrollUp { 
                box-shadow: '.esc_attr($epress_opt['scr_btn_shadow']).';
            }';
        }  
        if( isset( $epress_opt['post_box_box_shadow'] ) ){
            $custom_css[] = '.posts-list .post-content { 
                box-shadow: '.esc_attr($epress_opt['post_box_box_shadow']).';
            }';
        }  
        if( isset( $epress_opt['read_more_shadow'] ) ){
            $custom_css[] = '.post-content .read-more { 
                box-shadow: '.esc_attr($epress_opt['read_more_shadow']).';
            }';
        }  
        
        if( isset( $epress_opt['preloader_color'] ) ){
            $custom_css[] = '.preloader .loader-text h3 {
                background-image: -webkit-gradient(linear, left top, right top, from('.esc_attr($epress_opt['preloader_color']['from']).'), color-stop('.esc_attr($epress_opt['preloader_color']['to']).'), to('.esc_attr($epress_opt['preloader_color']['from']).'));
                background-image: linear-gradient(90deg, '.esc_attr($epress_opt['preloader_color']['from']).', '.esc_attr($epress_opt['preloader_color']['to']).', '.esc_attr($epress_opt['preloader_color']['from']).');
            }';
        }  
                  

        if( isset( $epress_opt['custom_css'] ) ){
            $custom_css[] = $epress_opt['custom_css'];
        }
                
        $custom_css = implode( ' ', $custom_css );
        wp_add_inline_style( 'epress-style', $custom_css );        
        
        
        
        // Add comment reply script.
        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
            wp_enqueue_script( 'comment-reply' );
        }
    }
}
add_action( 'wp_enqueue_scripts', 'epress_enqueue_scripts' );

// epress All Function Pack.
require get_theme_file_path('/inc/epress-function.php');
// Customizer Add Option.
require get_theme_file_path('/inc/customizer.php');
// Default Template Tag Functions.
require get_theme_file_path('/inc/template-tags.php');
// Important Plugin Activation.
require get_theme_file_path('/inc/epress-plugin-activation.php');
// OnePage Nav Waker Function.
require get_theme_file_path('/inc/nav-menu-walker.php');
// OnePage Nav Waker Function.
require get_theme_file_path('/inc/epress-option.php');
// Importer
require get_theme_file_path('/inc/importer.php');