<?php
/**
 * Single Give Form Title
 * 
 * Displays the main title for the single donation form - Override this template by copying it to yourtheme/give/single-give-form/title.php
 * 
 * @package     Give
 * @subpackage  templates/single-give-form
 * @copyright   Copyright (c) 2016, GiveWP
 * @license     https://opensource.org/licenses/gpl-license GNU Public License
 * @since       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$camp_author_name = get_the_author();
$camp_author_photo = get_avatar( get_the_author_meta('user_email') );

 ?>
<div class="author_details">
	<?php if(!empty($camp_author_photo)): ?>
	<div class="author-photo">
	<?php echo wp_kses_post($camp_author_photo); ?>
	</div>
	<?php endif; ?>
	<?php if( !empty($camp_author_name) ): ?>
	<span class="author-name"><?php echo esc_html($camp_author_name); ?></span>
	<?php endif; ?>
</div>
<h2 itemprop="name" class="give-form-title entry-title"><?php the_title(); ?></h2>
