<?php

function epress_backups_demos( $demos ) {
	
	$demo_content_installer	 = 'https://wp.quomodosoft.com/epress/content';
	$demos_array			 = array(

		'home_1'			 => array(
			'title'			 => esc_html__( 'Home V1', 'epress' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/home_1.jpg',
			'preview_link'	 => esc_url( 'https://wp.quomodosoft.com/epress' ),
		),
		
		'home_2'			 => array(
			'title'			 => esc_html__( 'Home V2', 'epress' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/home_2.jpg',
			'preview_link'	 => esc_url( 'https://wp.quomodosoft.com/epress/home-2' ),
		),
		
		'home_3'			 => array(
			'title'			 => esc_html__( 'Home V3', 'epress' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . '/home_3.jpg',
			'preview_link'	 => esc_url( 'https://wp.quomodosoft.com/epress/home-3' ),
		),
	);

	$download_url			 = esc_url( $demo_content_installer ) . '/download.php';
	
	foreach ( $demos_array as $id => $data ) {
		$demo = new FW_Ext_Backups_Demo( $id, 'piecemeal', array(
			'url'		 => $download_url,
			'file_id'	 => $id,
		) );
		$demo->set_title( $data[ 'title' ] );
		$demo->set_screenshot( $data[ 'screenshot' ] );
		$demo->set_preview_link( $data[ 'preview_link' ] );
		$demos[ $demo->get_id() ] = $demo;
		unset( $demo );
	}

	return $demos;
}

add_filter( 'fw:ext:backups-demo:demos', 'epress_backups_demos' );