<div <?php post_class('post-single'); ?> >   
    <?php    
        if ( class_exists( 'Redux' ) ) {
            global $epress_opt;
        }else{            
            $epress_opt = array();
            $epress_opt['is_blog_post_meta'] = $epress_opt['is_blog_post_title'] = $epress_opt['is_blog_post_image'] = true;    
            $epress_opt['read_more_switch'] = false;
            $epress_opt['meta_option_select'] = array( 'author','date','comment_count','category' );
            $epress_opt['blog_thumbnail_size'] = 'full';
            $epress_opt['blog_content_format'] = 'excerpt';
            $epress_opt['content_excerpt_length'] = '30';
            $epress_opt['title_excerpt_length'] = '15';
            $epress_opt['read_more_text'] = 'Read More <i class="flaticon-right-arrow"></i>';
        }    
        if( $epress_opt['is_blog_post_image'] == true ){
            if(get_post_meta( $id, '_epress_post_video_embed', true )){
                $video_url = get_post_meta( $id, '_epress_post_video_embed', true );
            }else{
                $video_url = '';
            }
            if( !empty($video_url) && function_exists('epress_video_embed_content') ):
                // Video Post Content Function
                echo epress_video_embed_content(esc_url($video_url));
            else:   
                epress_post_thumbnail($epress_opt['blog_thumbnail_size']); 
            endif;     
        }
    ?>
    <div class="post-content">       
        <?php            
        if(is_single() ):                
        /* translators: %s: Name of current post */
       ?>
       <div class="post-desc">
           <?php
                the_content(
                    sprintf(
                        esc_html__( 'Continue reading %s', 'epress' ),
                        the_title( '<span class="screen-reader-text">', '</span>', false )
                    )
                );
           ?>
       </div>
       <?php
        wp_link_pages( array(
            'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'epress' ) . '</span>',
            'after'       => '</div>',
            'link_before' => '<span class="page-numbers" >',
            'link_after'  => '</span>',
            'next_or_number' => 'number',
            'nextpagelink'     => '<i class="flaticon-right-arrow"></i>',
            'previouspagelink' => '<i class="flaticon-left-arrow-1"></i>',
        ) );  
        else:        
            if( $epress_opt['is_blog_post_title'] == true ){
                    echo '<h2 class="post-title"><a href="'.get_permalink().'" rel="bookmark">';
                    echo wp_trim_words( get_the_title(), $epress_opt['title_excerpt_length'], '...' );
                    echo '</a></h2>';
            }        
            if( $epress_opt['blog_content_format'] == 'excerpt' ){
                echo '<div class="post-desc">';
                echo wp_trim_words( get_the_content(), $epress_opt['content_excerpt_length'], '...' );
                echo '</div>';
                if( $epress_opt['read_more_switch'] == true and !empty($epress_opt['read_more_text']) ){
                    echo '<a class="read-more" href="'.get_the_permalink().'" >'.wp_kses_post($epress_opt['read_more_text']).'</a>';
                }
            }elseif( $epress_opt['blog_content_format'] == 'full' ){
                echo '<div class="post-desc">';
                the_content();
                echo '</div>';
            }
        endif;
        if( $epress_opt['is_blog_post_meta'] == true ){
            echo epress_header_post_meta( $epress_opt['meta_option_select'] );
        }    
        ?>
    </div>
</div>