<?php

if ( class_exists( 'Redux' ) ) {
    global $epress_opt;
}else{
    $epress_opt = array();
    $epress_opt['titlebar_align'] = 'center';
    $epress_opt['breadcrumb_home'] = 'Home';
    $epress_opt['breadcrumb_separator'] = '|';
    $epress_opt['sub_title_format'] = 1;
}


?>
<header class="header-area <?php echo esc_attr($epress_opt['titlebar_align']); ?>" >
    <div class="container">
        <div class="row">
            <div class="col-xs-12">
                <h3 class="page-title"><?php echo epress_page_title(); ?></h3>
                <?php
                    if( $epress_opt['sub_title_format'] == 1 ){
                        echo '<div class="sub-title site-description">'.get_bloginfo( 'description' ) .'</div>';
                    }elseif($epress_opt['sub_title_format'] == 2 and function_exists('epress_breadcrumb') ){
                        echo epress_breadcrumb($epress_opt['breadcrumb_home'],$epress_opt['breadcrumb_separator']);
                    }elseif($epress_opt['sub_title_format'] == 3 and !empty($epress_opt['custom_sub_title']) ){
                        echo '<div class="sub-title">'. wp_kses_post($epress_opt['custom_sub_title']) .'</div>';
                    }
                ?>
            </div>
        </div>
    </div>
</header>