<?php
/**
 * The template for displaying form content in the single-give-form.php template
 *
 * Override this template by copying it to yourtheme/give/single-give-form/content-single-give-form.php
 *
 * @package       Give/Templates
 * @version       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Fires in single form template, before the form.
 *
 * Allows you to add elements before the form.
 *
 * @since 1.0
 */
do_action( 'give_before_single_form' );

if ( post_password_required() ) {
	echo get_the_password_form();
	return;
}
?>
	<div id="give-form-<?php the_ID(); ?>-content" <?php post_class(); ?>>
		<?php
			add_action( 'epress_give_single_image', 'give_show_form_images', 10 );
			do_action( 'epress_give_single_image' );
			do_action( 'give_single_form_summary' );
			do_action( 'give_after_single_form_summary' );
		?>
	</div><!-- #give-form-<?php the_ID(); ?> -->
<?php
/**
 * Fires in single form template, after the form.
 *
 * Allows you to add elements after the form.
 *
 * @since 1.0
 */
do_action( 'give_after_single_form' );
?>
