<?php
  $form_id = get_the_ID();
  $form = new Give_Donate_Form( $form_id );
  $goal = apply_filters( 'give_goal_amount_target_output', $form->goal, $form_id, $form );
  $goal_option = give_get_meta( $form_id, '_give_goal_option', true );
  $progress = 0;
  $income = apply_filters( 'give_goal_amount_raised_output', $form->get_earnings(), $form_id, $form );
  $income = empty($income) ? 0 : $income;

   if($goal_option == 'disabled' || !$goal_option){
      $goal = 'unlimited';
      $progress = 100;
      $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
   }

  if($goal == 'unlimited'){
	 $progress_label = esc_html__( 'unlimited' , 'paroti' );
	 $progress = 100;
   $goal = $progress_label;
  }else{
  	if($goal == 0) $goal = 1;
	 $progress = apply_filters( 'give_goal_amount_funded_percentage_output', round( ( $income / $goal ) * 100, 1 ), $form_id, $form );
	 $progress_label = $progress . '%';
	 $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
    $goal = give_currency_filter(give_format_amount( $goal, array( 'sanitize' => false ) ));
	 if($progress > 100) $progress = 100;
  }

   $post_category = ''; $separator = ' '; $output = '';
   $item_cats = get_the_terms( get_the_ID(), 'give_forms_category' );
   if(!empty($item_cats) && !is_wp_error($item_cats)){
      foreach((array)$item_cats as $item_cat){
         $output .= '<a href="' . esc_url(get_category_link( $item_cat->term_id )) . '" title="' . esc_attr( sprintf( esc_attr__( "View all campaign in %s", 'paroti' ), $item_cat->name ) ) . '">'.$item_cat->name.'</a>'.$separator;
      }
      $post_category = trim($output, $separator);
   }

	$thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'paroti_medium';
   $excerpt_words = (isset($excerpt_words) && $excerpt_words) ? $excerpt_words : '30';
?> 

<div class="give-block-2">
	<div class="give-form-category"><?php echo html_entity_decode($post_category) ?></div>
	
	<?php get_template_part( 'give/part', 'media' ); ?>
	
	<div class="give_form-content">
		<div class="give-form-content-inner">
			<div class="gf-content-inner">
			  <h2 class="title"><a href="<?php esc_url(the_permalink()) ?>"><?php the_title() ?></a></h2>
			  <div class="desc"><?php echo paroti_limit_words( $excerpt_words, get_the_excerpt(), get_the_content() ); ?></div>
			</div>  
			<div class="gf-content-footer clearfix">
		  	   <div class="form-process">
               <div class="funded">
                  <div class="give__progress">
                     <div class="give__progress-bar" data-progress-animation="<?php echo esc_attr($progress)?>%">
                        <?php if($progress > 12){ ?>
                           <span class="percentage percentage-left"><?php echo esc_html($progress_label); ?></span>
                        <?php }else{ ?>
                           <span class="percentage"><?php echo esc_html($progress_label); ?></span>
                        <?php } ?>  
                     </div>
                  </div>
               </div>
            </div>
			  	<div class="campaign-information clearfix">
				 	<div class="campaign-goal"> 
						<span class="value"><?php echo esc_html($goal) ?></span>
						<span class="label"><?php echo esc_html__('Goal', 'paroti') ?></span> 
				 	</div>
				 	<div class="campaign-raised">
						<span class="value"><?php echo esc_html($income) ?></span>
						<span class="label"><?php echo esc_html__('Raised', 'paroti') ?></span> 
				 	</div>
				</div>
				<div class="campaign-action">
					<a class="btn-donate-white" href="<?php esc_url(the_permalink()) ?>"><?php echo esc_html__('Donate Now', 'paroti') ?></a>
				</div>
			</div>
		</div>

	</div>
</div>

	 
