<?php
   $form_id = get_the_ID();
   $form = new Give_Donate_Form( $form_id );
   $goal = apply_filters( 'give_goal_amount_target_output', $form->goal, $form_id, $form );
   $goal_option = give_get_meta( $form_id, '_give_goal_option', true );
   $progress = 0;
   $togo = 0;
   $income = apply_filters( 'give_goal_amount_raised_output', $form->get_earnings(), $form_id, $form );
   $income = empty($income) ? 0 : $income;

   $progress_color = give_get_meta($form_id, '_give_goal_color', true);

   if($goal_option == 'disabled' || !$goal_option){
      $goal = 'unlimited';
      $progress = 100;
      $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
   }

  if($goal == 'unlimited'){
      $progress_label = esc_html__( 'unlimited' , 'paroti' );
      $progress = 100;
      $togo = $goal = esc_html__("Unlimited", 'paroti');
  }else{
  		if($goal == 0) $goal = 1;
      $progress = apply_filters( 'give_goal_amount_funded_percentage_output', round( ( $income / $goal ) * 100, 1 ), $form_id, $form );
      $progress_label = $progress . '%';
      $income = give_currency_filter(give_format_amount( $income, array( 'sanitize' => false ) ));
      $goal = give_currency_filter(give_format_amount( $goal, array( 'sanitize' => false ) ));
      if($progress > 100) $progress = 100;
  }

   $post_category = ''; $separator = ' '; $output = '';
   $item_cats = get_the_terms( get_the_ID(), 'give_forms_category' );
   if(!empty($item_cats) && !is_wp_error($item_cats)){
      foreach((array)$item_cats as $item_cat){
         $output .= '<a href="' . esc_url(get_category_link( $item_cat->term_id )) . '" title="' . esc_attr( sprintf( esc_attr__( "View all campaign in %s", 'paroti' ), $item_cat->name ) ) . '">'.$item_cat->name.'</a>'.$separator;
      }
      $post_category = trim($output, $separator);
   }

   $progress_color = give_get_meta($form_id, 'paroti_give_color', true);
   $style_color = $progress_color ? 'style="--give-color:' . esc_attr($progress_color) . '"' : '';

   $thumbnail = (isset($thumbnail_size) && $thumbnail_size) ? $thumbnail_size : 'paroti_medium';
   $excerpt_words = (isset($excerpt_words) && $excerpt_words) ? $excerpt_words : '30';
?> 

<div class="give-block-totals style-1" <?php echo trim($style_color) ?>>
	<div <?php post_class('give-form'); ?>>
		<div class="content-left">

         <?php
            if(isset($left_sub_title) && $left_sub_title){
   			   echo '<div class="subtitle">' .  $left_sub_title . '</div>';
            }
            if(isset($left_title) && $left_title){
			      echo '<h2 class="title">' . $left_title . '</h2>';
            }
         ?>
			<div class="form-content">
				<div class="form-content-inner">
					<div class="give-form-inner">
						<?php give_get_donation_form( array('show_title' =>false, 'id' => $form_id, 'display_style' => 'modal', 'continue_button_title' => esc_html__('Donate', 'paroti'), 'float_labels' => 'global', 'show_content' => 'none') ) ?>
					</div>
				</div>  
			 </div>
		</div>
		<div class="content-right">
			<div class="content-inner">
            <?php 
               if(isset($right_title) && $right_title){
                  echo '<h2 class="title">' . $right_title . '</h2>';
               }
               if(isset($right_desc) && $right_desc){
                  echo '<div class="desc">' . $right_desc . '</h2>';
               }
            ?>
            <div class="give-form-raised clearfix">
               <div class="form-process">
                  <div class="funded">
                     <div class="give__progress">
                        <div class="give__progress-bar" data-progress-animation="<?php echo esc_attr($progress)?>%">
                           <?php if($progress > 12){ ?>
                              <span class="percentage percentage-left"><?php echo esc_html($progress_label); ?></span>
                           <?php }else{ ?>
                              <span class="percentage"><?php echo esc_html($progress_label); ?></span>
                           <?php } ?>  
                        </div>
                     </div>
                  </div>
               </div>
               <div class="campaign-information clearfix">
                  <div class="campaign-goal"> 
                     <span class="value"><?php echo esc_html($goal) ?></span>
                     <span class="label"><?php echo esc_html__('Goal', 'paroti') ?></span> 
                  </div>
                  <div class="campaign-raised">
                     <span class="value"><?php echo esc_html($income) ?></span>
                     <span class="label"><?php echo esc_html__('Raised', 'paroti') ?></span> 
                  </div>
               </div>
            </div>

			</div>
		</div>	
	</div>
</div>

