<?php
function paroti_register_meta_boxes(){
	$prefix = 'paroti_';
	global $meta_boxes;
	$meta_boxes = array();

	/* ====== Metabox Template ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'paroti'),
		'pages' => array( 'gva__template'),
		'priority'   => 'high',
		'fields' => array(
			array(
				'name' => esc_html__('Template Type', 'paroti'),
				'id'   => "gva_template_type",
				'type' => 'text'
			),
		)
	);

	/* ====== Metabox Page ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'paroti'),
		'pages' => array( 'page'),
		'priority'   => 'high',
		'fields' => array(
			array(
            'name' => esc_html__('Full Width', 'paroti'),
            'id'   => "{$prefix}page_full_width",
            'type' => 'switch',
            'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'paroti'),
            'std' => 0,
         ),
			array(
				'name' => esc_html__('Header Layout', 'paroti'),
				'id'   => "{$prefix}header_layout",
				'type' => 'select',
				'options' => paroti_list_header_layout(),
				'multiple' => false,
				'std'  => '_default_active',
			),
			array(
				'name' => esc_html__('Footer Layout', 'paroti'),
				'id'   => "{$prefix}footer_layout",
				'type' => 'select',
				'options' => paroti_list_footer_layout(),
				'multiple' => false,
				'std'  => '_default_active',
			),
			array(
				'name' => esc_html__('Extra page class', 'paroti'),
				'id' => $prefix . 'extra_page_class',
				'desc' => esc_html__("If you wish to add extra classes to the body class of the page (for custom css use), then please add the class(es) here.", 'paroti'),
				'clone' => false,
				'type'  => 'text',
				'std' => '',
			),
		)
	);

	/* ====== Metabox Page Title ====== */
	$meta_boxes[] = array(
		'id' => 'gavias_metaboxes_page_heading',
		'title' => esc_html__('Page Title & Breadcrumb', 'paroti'),
		'pages' => array( 'post', 'page', 'product', 'portfolio', 'tribe_events'),
		'context' => 'normal',
		'priority'   => 'high',
		'fields' => array(
		  	array(
				'name' => esc_html__('Remove Title of Page', 'paroti'),   
				'id'   => "{$prefix}disable_page_title",
				'type' => 'switch',
				'std'  => 0,
		  	),
		  	array(
			 	'name' => esc_html__('Disable Breadcrumbs', 'paroti'),
			 	'id'   => "{$prefix}no_breadcrumbs",
			 	'type' => 'switch',
			 	'desc' => esc_html__('Disable the breadcrumbs from under the page title on this page.', 'paroti'),
			 	'std' => 0,
		  	),
		  	array(
			 	'name' => esc_html__('Breadcrumb Layout', 'paroti'),
			 	'id'   => "{$prefix}breadcrumb_layout",
			 	'type' => 'select',
			 	'options' => array(
				 	'layout_options'    => esc_html__('Default Options in Layout Template', 'paroti'),
				 	'page_options'      => esc_html__('Individuals Options This Page', 'paroti')
			 	),
			 	'multiple' => false,
			 	'std'  => 'theme_options',
			 	'desc' => esc_html__('You can use breadcrumb settings default in Layout Template or individuals this page', 'paroti')
		  	),
		  	array(
			 	'name' 	=> esc_html__( 'Background Overlay Color', 'paroti' ),
			 	'id'   	=> "{$prefix}paroti_breacrumb_bg_color",
			 	'desc' 	=> esc_html__( "Set an overlay color for hero heading image.", 'paroti' ),
			 	'type' 	=> 'color',
			 	'class' => 'breadcrumb_setting',
			 	'std'  	=> '',
		  	),
		  	array(
			 	'name'       => esc_html__( 'Overlay Opacity', 'paroti' ),
			 	'id'         => "{$prefix}breacrumb_bg_opacity",
			 	'desc'       => esc_html__( 'Set the opacity level of the overlay. This will lighten or darken the image depening on the color selected.', 'paroti' ),
			 	'clone'      => false,
			 	'type'       => 'slider',
			 	'prefix'     => '',
			 	'class'   	  => 'breadcrumb_setting',
			 	'js_options' => array(
				  	'min'  => 0,
				  	'max'  => 100,
				  	'step' => 1,
			 	),
			 	'std'   => '50'
		  	),
		  	array(
			 	'name'  	=> esc_html__('Breadcrumb Background Image', 'paroti'),
			 	'id'    	=> "{$prefix}paroti_breacrumb_image",
			 	'type'  	=> 'image_advanced',
			 	'class'   	=> 'breadcrumb_setting',
			 	'max_file_uploads' => 1
		  	),
		)
	);

	$meta_boxes[] = array(
    	'id'    		=> 'metaboxes_give_forms',
    	'title' 		=> esc_html__('Give Forms Settings', 'paroti'),
    	'pages' 		=> array( 'give_forms' ),
    	'priority' 	=> 'high',
    	'fields' 	=> array(
	     	array (
	        	'name'   => esc_html__('Gallery Images', 'paroti'),
	        	'id'    	=> "{$prefix}give_gallery_images",
	        	'type'             => 'image_advanced',
	        	'max_file_uploads' => 50,
	      ),
	      array(
	        	'name' => esc_html__('Video URL', 'paroti'),
	        	'id' 	 => $prefix . 'give_video_url',
	        	'type' => 'text'
	      ),
	      array(
	        	'name' => esc_html__('Featured', 'paroti'),   
	        	'id'   => "{$prefix}give_featured",
	        	'type' => 'checkbox',
	        	'std'  => 0,
	      ),
	      array(
			 	'name' 	=> esc_html__( 'Color', 'paroti' ),
			 	'id'   	=> "{$prefix}give_color",
			 	'type' 	=> 'color'
		  	),
		  	array(
				'name' => esc_html__('Layout Page', 'paroti'),
				'id'   => "{$prefix}template_layout",
				'type' => 'select',
				'options' => paroti_get_donation_layout(),
				'multiple' => false,
				'std'  => '_default_active',
			),
    	)
  	);

	return $meta_boxes;
 }  
  /********************* META BOX REGISTERING ***********************/
  add_filter( 'rwmb_meta_boxes', 'paroti_register_meta_boxes' , 99 );

