<?php
Redux::setSection( $opt_name, array(
	'title' => esc_html__('General Options', 'paroti'),
	'icon' => 'el-icon-wrench',
	'fields' => array(
		array(
			'id'           => 'page_layout',
			'type'         => 'button_set',
			'title'        => esc_html__('Page Layout', 'paroti'),
			'subtitle'     => esc_html__('Select the page layout type', 'paroti'),
			'options'      => array(
				'boxed'     => esc_html__('Boxed', 'paroti'),
				'fullwidth' => esc_html__('Fullwidth', 'paroti')
			),
			'default' => 'fullwidth'
		),
      array(
        'id' => 'map_api_key',
        'type' => 'text',
        'title' => esc_html__('Google Map API key', 'paroti'),
        'default' => ''
      ),

		// Breadcrumb Default Settings
		array(
         'id'     => 'breadcrumb_default',
         'type'   => 'info',
         'icon'   => true,
         'raw'    => '<h3 class="margin-bottom-0">' . esc_html__('Breadcrumb Settings Without Elementor', 'paroti') . '</h3>',
      ),
		array(
         'id'        => 'breadcrumb_title',
         'type'      => 'button_set',
         'title'     => esc_html__('Breadcrumb Title', 'paroti'),
         'options'   => array(
            1 => esc_html__('Enable', 'paroti'),
            0 => esc_html__('Disable', 'paroti')
         ),
         'default'   => 1
      ),
      array(
         'id'        => 'breadcrumb_bg_color',
         'type'      => 'color',
         'title'     => esc_html__('Background Overlay Color', 'paroti'),
         'default'   => ''
      ),
      array(
         'id'        => 'breadcrumb_bg_opacity',
         'type'      => 'slider',
         'title'     => esc_html__('Breadcrumb Ovelay Color Opacity', 'paroti'),
         'default'   => 50,
         'min'       => 0,
         'max'       => 100,
         'step'      => 2,
         'display_value' => 'text',
      ),
      array(
         'id'        => 'breadcrumb_bg_image',
         'type'      => 'media',
         'url'       => true,
         'title'     => esc_html__('Breadcrumb Background Image', 'paroti'),
         'default'   => '',
      ),
      array(
         'id'        => 'breadcrumb_text_stype',
         'type'      => 'select',
         'title'     => esc_html__('Breadcrumb Text Stype', 'paroti'),
         'options'   => 
         array(
            'text-light'     => esc_html__('Light', 'paroti'),
            'text-dark'      => esc_html__('Dark', 'paroti')
         ),
         'default' => 'text-light'
      )
	)
));